//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// HeapAllocationDlg.cpp : plik implementacji
//

#include "stdafx.h"
#include "HeapAllocation.h"
#include "HeapAllocationDlg.h"
#include "LinkedList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// Okno dialogowe CAboutDlg uywane przez App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dane okna dialogowego
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // Obsuga DDX/DDV

// Implementacja
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// Okno dialogowe CHeapAllocationDlg



CHeapAllocationDlg::CHeapAllocationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHeapAllocationDlg::IDD, pParent)
{
	head = NULL;
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CHeapAllocationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ALLOCATETIME, allocateTimeCtrl);
	DDX_Control(pDX, IDC_DEALLOCATETIME, deallocateTimeCtrl);
}

BEGIN_MESSAGE_MAP(CHeapAllocationDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_ALLOCATEBUTTON, OnAllocate)
	ON_BN_CLICKED(IDC_DEALLOCATEBUTTON, OnDeallocate)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


// Procedury obsugi wiadomoci CHeapAllocationDlg

BOOL CHeapAllocationDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Dodaje element menu "O programie..." do menu systemowego.

	// IDM_ABOUTBOX musi znajdowa si w zasigu polece systemowych.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Ustawienie ikonki dla tego okna dialogowego. Struktura wykonuje to automatycznie,
	//  jeli gwne okno aplikacji nie jest oknem dialogowym.
	SetIcon(m_hIcon, TRUE);			// Ustawienie duej ikonki
	SetIcon(m_hIcon, FALSE);		// Ustawienie maej ikonki

	head = new LinkedList();
	
	GetDlgItem(IDC_ALLOCATEBUTTON)->EnableWindow(TRUE);
	GetDlgItem(IDC_DEALLOCATEBUTTON)->EnableWindow(FALSE);

	return TRUE;  // zwrcenie TRUE, chyba e ognisko ustawiono na element sterujcy
}

void CHeapAllocationDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// Jeli do okna dialogowego zostanie dodany przycisk minimalizacji, poniszy kod bdzie niezbdny
//  do przecigania ikonki. W przypadku aplikacji MFC korzystajcych z modelu dokument/widok
//  zostanie to wykonane automatycznie przez struktur.

void CHeapAllocationDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // kontekst urzdzenia sucy do rysowania

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Wyporodkowanie ikonki w prostokcie klienta
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Rysowanie ikonki
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// System wywouje t funkcj w celu uzyskania wskanika, kiedy uytkownik przeciga
//  zminimalizowane okno.
HCURSOR CHeapAllocationDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CHeapAllocationDlg::OnAllocate()
{
	if(head == NULL)
	{
		head = new LinkedList();
	}
	__int64 start, stop, freq;
	QueryPerformanceCounter((LARGE_INTEGER*)&start);
	LinkedList *node = NULL;
	for(int i = 0;i < 100000;i++)
	{
		node = new LinkedList(head);
		head = node;
	}
	QueryPerformanceCounter((LARGE_INTEGER*)&stop);
	QueryPerformanceFrequency((LARGE_INTEGER*)&freq);
	double elapsed = (double)(stop - start)/(double)freq;
	TCHAR buffer[64];
	_stprintf(buffer, _T("%.3lf"), elapsed * 1000.0);
	allocateTimeCtrl.SetWindowText(buffer);
	GetDlgItem(IDC_DEALLOCATEBUTTON)->EnableWindow(TRUE);
}

void CHeapAllocationDlg::OnDeallocate()
{
	__int64 start, stop, freq;
	QueryPerformanceCounter((LARGE_INTEGER*)&start);
	LinkedList *node = head;
	LinkedList *temp;
	while(node)
	{
		temp = node->link;
		delete node;
		node = temp;
	}
	head = NULL;
	QueryPerformanceCounter((LARGE_INTEGER*)&stop);
	QueryPerformanceFrequency((LARGE_INTEGER*)&freq);
	double elapsed = (double)(stop - start)/(double)freq;
	TCHAR buffer[64];
	_stprintf(buffer, _T("%.3lf"), elapsed * 1000.0);
	deallocateTimeCtrl.SetWindowText(buffer);
	GetDlgItem(IDC_DEALLOCATEBUTTON)->EnableWindow(FALSE);
}

void CHeapAllocationDlg::OnClose()
{
	LinkedList *node = head;
	LinkedList *temp;
	while(node)
	{
		temp = node->link;
		delete node;
		node = temp;
	}
	head = NULL;
	CDialog::OnClose();
}
